/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xutil.c
 * -----------------------------------------------------------------*/

#include <xtypedef.h>
#include <xutil.h>

#ifdef _XDEBUG
char BestXDbgbuffer [1024];
#endif

/*#define BESTX_MEM_TEST*/

#ifdef BESTX_MEM_TEST
static bx_int32 global_allmem_alloc=0;
static bx_int32 global_allmem_free=0;
static bx_int32 alloc_calls=0;
static bx_int32 free_calls=0;
#endif
/********************************************************************
  Memory allocation *************************************************
********************************************************************/

/*---------------------------------------------------------------------------*
 * void EXPORT * BestXMemCalloc(size_t num, size_t size)
 *
 * Purpose      : allocate memory and intialize w/ zero
 *---------------------------------------------------------------------------*/
void EXPORT * BestXMemCalloc(size_t num, size_t size)
{ 
  void * mem;

  
#ifdef BESTX_MEM_TEST 
  alloc_calls+=1;
  mem=calloc(num,size+4); /* inits completely to zero ! */
  ((bx_int32ptr)mem)[0]=(bx_int32)num*(bx_int32)size;
  global_allmem_alloc+=(bx_int32)num*(bx_int32)size;
  printf("A %d c %d;",global_allmem_alloc,alloc_calls);
  return (void*) (((char *)mem)+4);
#else
  mem=calloc(num,size); /* inits completely to zero ! */
  
#if 0
  if (mem)
  {
    /* Because many properties default to zero,
       it is often easier to debug, when memory
       is initialized with 0xff 
     */
    BESTX_MEMSET(mem,0xff,num*size);
  }
#endif
  return mem;
#endif
}

/*  ---------------------------------------------------------------------------*
 * void *BestXMemMalloc(size_t size)
 *
 * Purpose      : allocate memory
 *---------------------------------------------------------------------------*/
void EXPORT * BestXMemMalloc(size_t size)
{
  return BestXMemCalloc(1,size);
}

/*---------------------------------------------------------------------------*
 * void *BestXMemRealloc(void *memptr,size_t size)
 *
 * Purpose      : allocate memory w/ new size
 *---------------------------------------------------------------------------*/
void EXPORT * BestXMemRealloc(void *memptr,size_t size)
{
#ifdef BESTX_MEM_TEST
  void * mem;
  bx_int32ptr previous;
  alloc_calls+=1;
  if(memptr!=NULL)
  {
    previous=((bx_int32ptr)memptr-1);
    global_allmem_alloc-=*previous;
    /* printf("%d -> %d;",*previous,(bx_int32) size);*/
    mem=realloc((void*)((char *)memptr-4),size+4);
  }
  else
  {
    /*printf("%d;",(bx_int32) size); */
    mem=realloc(memptr,size+4);
  }

  global_allmem_alloc+=(bx_int32)size;
  printf("A %d c %d;",global_allmem_alloc,alloc_calls);
  ((bx_int32ptr)mem)[0]=(bx_int32)size; 

  return (void*) (((char *)mem)+4);
#else
  return realloc(memptr,size);
#endif
}

/*---------------------------------------------------------------------------*
 * void BestXMemFree(void ** memptr)
 *
 * Purpose      : free allocated memory
 *---------------------------------------------------------------------------*/
void EXPORT BestXMemFree(void ** memptr)
{

  if (memptr==NULL||*memptr==NULL)
  {
    return;
  }
#ifdef BESTX_MEM_TEST
  free_calls+=1;
  global_allmem_free+=*(((bx_int32ptr)(*memptr))-1);
  printf("F %d c %d;",global_allmem_alloc-global_allmem_free,free_calls);
  free ((bx_int32ptr)*memptr-1);
#else
  free (*memptr);
#endif
  *memptr=NULL;
}


